package com.bytesbee.mysinglelivechannel.activities;

import static com.bytesbee.mysinglelivechannel.utils.Constant.CLICK_DELAY_TIME;
import static com.bytesbee.mysinglelivechannel.utils.Constant.DEFAULT_DELAY;
import static com.bytesbee.mysinglelivechannel.utils.Constant.DEFAULT_UPDATE_URL;
import static com.bytesbee.mysinglelivechannel.utils.Constant.FALSE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.FOUR;
import static com.bytesbee.mysinglelivechannel.utils.Constant.ONE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TEN_SECOND_TIME;
import static com.bytesbee.mysinglelivechannel.utils.Constant.THREE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TRUE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TWO;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TYPE_LIST;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TYPE_STREAMING;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TYPE_YOUTUBE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.ZERO;

import android.annotation.SuppressLint;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.api.ApiInterface;
import com.bytesbee.mysinglelivechannel.api.RestAdapter;
import com.bytesbee.mysinglelivechannel.async.BaseTask;
import com.bytesbee.mysinglelivechannel.async.TaskRunner;
import com.bytesbee.mysinglelivechannel.callbacks.CallbackChannel;
import com.bytesbee.mysinglelivechannel.callbacks.CallbackUser;
import com.bytesbee.mysinglelivechannel.fcm.NotificationUtils;
import com.bytesbee.mysinglelivechannel.managers.Screens;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.models.Channel;
import com.bytesbee.mysinglelivechannel.models.Setting;
import com.bytesbee.mysinglelivechannel.utils.Constant;
import com.bytesbee.mysinglelivechannel.utils.Utils;
import com.bytesbee.mysinglelivechannel.views.TrackSelectionDialog;
import com.bytesbee.mysinglelivechannel.views.spinner.NiceSpinner;
import com.bytesbee.mysinglelivechannel.views.webview.VideoEnabledWebChromeClient;
import com.bytesbee.mysinglelivechannel.views.webview.VideoEnabledWebView;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.util.Util;
import com.google.android.material.snackbar.Snackbar;
import com.kongzue.dialogx.dialogs.MessageDialog;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.PlayerConstants;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.FullscreenListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.options.IFramePlayerOptions;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView;

import java.util.LinkedList;
import java.util.List;

import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * @noinspection ALL
 */
public class MainActivity extends BaseAppActivity {

    private long exitTime = 0;

    //Common Components
    private ImageView imgChannel;
    private TextView txtChannelName, txtChannelCount;
    private WebView txtDescription;
    private String streamLinkPlaying;
    private int bTotalCount = -1;
    private Channel obj;
    private View mainContainer;
    private NiceSpinner niceSpinner;
    private List<String> dataset;

    //ExoPlayer
    private StyledPlayerView exoPlayerView;
    private ExoPlayer simpleExoPlayer;
    private boolean isShowingTrackSelectionDialog;
    private DefaultTrackSelector trackSelector;
    String[] speed = {"0.25x", "0.5x", "Normal", "1.5x", "2x"};

    //New YouTube (v1.3)
    private RelativeLayout layoutVideo;
    private YouTubePlayer mYouTubePlayer;
    private YouTubePlayerView youTubePlayerView;
    private FrameLayout full_screen_view_container;
    private String strVideoId, strType;

    //Embedded Player
    private View nonVideoLayout, videoLayout;
    private VideoEnabledWebView mWebView;
    private VideoEnabledWebChromeClient webChromeClient;

    private boolean isFullscreen;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);
        isFullscreen = SessionManager.get().isFullscreenOn();

        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);

        initView();

        requestAction();

        Utils.requestSettingApi(getApplicationContext(), dataHandler);

        Utils.showBannerAd(mActivity);
        Utils.loadFirstTimeInterstitialAds(mActivity);//Only load first time from here.

        final NotificationUtils notificationUtils = new NotificationUtils(getApplicationContext());
        notificationUtils.checkFCMTokenUpdated(mActivity);
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void initView() {
        try {
            final Toolbar toolbar = findViewById(R.id.toolbar);
            toolbar.setTitle(R.string.lblLiveChannel);
            toolbar.inflateMenu(R.menu.menu_setting);
            toolbar.setOnMenuItemClickListener(item -> {
                if (item.getItemId() == R.id.setting) {
                    Screens.showCustomScreen(mActivity, SettingsActivity.class);
                }
                return false;
            });
        } catch (Exception e) {
            Utils.getErrors(e);
        }

        mainContainer = findViewById(R.id.mainContainer);
        imgChannel = findViewById(R.id.imgChannel);
        txtChannelName = findViewById(R.id.txtChannelName);
        txtChannelCount = findViewById(R.id.txtChannelCount);
        txtDescription = findViewById(R.id.txtDescription);

        layoutVideo = findViewById(R.id.layoutVideo);
        mWebView = findViewById(R.id.embeddedWebView);
        nonVideoLayout = findViewById(R.id.nonVideoLayout);
        videoLayout = findViewById(R.id.videoLayout);

        //== ExoPlayer
        exoPlayerView = findViewById(R.id.exoPlayerView);
        trackSelector = new DefaultTrackSelector(this);
        simpleExoPlayer = new ExoPlayer.Builder(this).setTrackSelector(trackSelector).build();
        exoPlayerView.setPlayer(simpleExoPlayer);
        exoCustomControl(View.VISIBLE);

        exoPlayerView.setVisibility(View.GONE);
        layoutVideo.setVisibility(View.GONE);
        mWebView.setVisibility(View.GONE);

        niceSpinner = findViewById(R.id.nice_spinner);
        dataset = new LinkedList<>();

        mWebView.setFocusableInTouchMode(false);
        mWebView.setFocusable(false);
        mWebView.getSettings().setDefaultTextEncodingName("UTF-8");
        mWebView.getSettings().setJavaScriptEnabled(true);
        mWebView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        mWebView.getSettings().setSupportMultipleWindows(true);
        mWebView.getSettings().setDomStorageEnabled(true);
        mWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);

        mWebView.setWebViewClient(new WebViewClient() {
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                mWebView.setVisibility(View.VISIBLE);
            }
        });

        niceSpinner.setOnSpinnerItemSelectedListener((parent, view, position, id) -> {
            if (obj != null) {
                openVideo();
            }
        });

        imgChannel.setOnClickListener(view -> Screens.showClearTopScreen(mActivity, MainActivity.class));

    }

    private void exoCustomControl(int visible) {
        ImageView btnForward = exoPlayerView.findViewById(R.id.fwd);
        ImageView btnRew = exoPlayerView.findViewById(R.id.rew);
        ImageView btnSetting = exoPlayerView.findViewById(R.id.exo_track_selection_view);
        ImageView btnSpeed = exoPlayerView.findViewById(R.id.exo_playback_speed);
        ImageView exo_play = exoPlayerView.findViewById(R.id.exo_play);
        ImageView exo_pause = exoPlayerView.findViewById(R.id.exo_pause);
        ImageView fullscreenButton = exoPlayerView.findViewById(R.id.fullscreen);

        try {
            TextView exo_duration = exoPlayerView.findViewById(R.id.exo_duration);
            TextView textView = exoPlayerView.findViewById(R.id.textView);
            TextView exo_position = exoPlayerView.findViewById(R.id.exo_position);
            exo_duration.setVisibility(visible);
            textView.setVisibility(visible);
            exo_position.setVisibility(visible);
        } catch (Exception ignored) {

        }

        btnForward.setVisibility(visible);
        btnRew.setVisibility(visible);
        btnSetting.setVisibility(visible);
        btnSpeed.setVisibility(visible);
        exo_play.setVisibility(visible);
        exo_pause.setVisibility(visible);
        fullscreenButton.setVisibility(visible);

        exo_play.setOnClickListener(v -> {
            simpleExoPlayer.play();
            exo_play.setVisibility(View.GONE);
            exo_pause.setVisibility(View.VISIBLE);
        });

        exo_pause.setOnClickListener(v -> {
            simpleExoPlayer.pause();
            exo_pause.setVisibility(View.GONE);
            exo_play.setVisibility(View.VISIBLE);
        });

        try {
            if (simpleExoPlayer.isPlaying()) {
                exo_play.setVisibility(View.GONE);
                exo_pause.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        btnSpeed.setOnClickListener(v -> {
            final AlertDialog.Builder builder = new AlertDialog.Builder(mActivity);
            builder.setTitle(R.string.speed_title);
            builder.setItems(speed, (dialog, which) -> {
                // the user clicked on colors[which]
                float value = 1f;
                if (which == ZERO) {
                    value = 0.25f;
                } else if (which == ONE) {
                    value = 0.5f;
                } else if (which == TWO) {
                    value = 0.1f;
                } else if (which == THREE) {
                    value = 1.5f;
                } else if (which == FOUR) {
                    value = 2f;
                }
                PlaybackParameters param = new PlaybackParameters(value);
                simpleExoPlayer.setPlaybackParameters(param);
            });
            builder.show();
        });

        btnForward.setOnClickListener(v -> simpleExoPlayer.seekTo(simpleExoPlayer.getCurrentPosition() + TEN_SECOND_TIME));

        btnRew.setOnClickListener(v -> {
            long num = simpleExoPlayer.getCurrentPosition() - TEN_SECOND_TIME;
            if (num < ZERO) {
                simpleExoPlayer.seekTo(ZERO);
            } else {
                simpleExoPlayer.seekTo(simpleExoPlayer.getCurrentPosition() - TEN_SECOND_TIME);
            }
        });

        fullscreenButton.setOnClickListener(view -> {
            int orientation = getResources().getConfiguration().orientation;
            if (orientation == Configuration.ORIENTATION_PORTRAIT) {
                hideShowOtherComponent(View.GONE);
            } else {
                hideShowOtherComponent(View.VISIBLE);
            }
        });

        btnSetting.setOnClickListener(v -> {
            if (!isShowingTrackSelectionDialog && TrackSelectionDialog.willHaveContent(simpleExoPlayer)) {
                isShowingTrackSelectionDialog = true;
//                TrackSelectionDialog trackSelectionDialog = TrackSelectionDialog.createForTrackSelector(trackSelector, dismissedDialog -> isShowingTrackSelectionDialog = false);
//                final androidx.fragment.app.FragmentManager fragmentManager = ((AppCompatActivity) mActivity).getSupportFragmentManager();
//                trackSelectionDialog.show(fragmentManager, "null");
                TrackSelectionDialog trackSelectionDialog = TrackSelectionDialog.createForPlayer(simpleExoPlayer, dismissedDialog -> isShowingTrackSelectionDialog = false);
                final androidx.fragment.app.FragmentManager fragmentManager = ((AppCompatActivity) mActivity).getSupportFragmentManager();
                trackSelectionDialog.show(fragmentManager, "null");

            }
        });
    }

    private void hideShowOtherComponent(int isVisible) {
        try {
            findViewById(R.id.appbar).setVisibility(isVisible);
            findViewById(R.id.topLayout).setVisibility(isVisible);
            findViewById(R.id.descriptionLayout).setVisibility(isVisible);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
        try {
            boolean fullscreen = isVisible == View.GONE;
            if (fullscreen) {
                try {
                    exoPlayerView.setResizeMode(AspectRatioFrameLayout.RESIZE_MODE_FIXED_HEIGHT);
                } catch (Exception e) {
                }
                setRequestedOrientation(LANDSCAPE_ORIENTATION);
                WindowManager.LayoutParams attrs = getWindow().getAttributes();
                attrs.flags |= WindowManager.LayoutParams.FLAG_FULLSCREEN;
                attrs.flags |= WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
                getWindow().setAttributes(attrs);
                getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LOW_PROFILE
                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                    attrs.flags |= WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS;
                    getWindow().setAttributes(attrs);
                }
            } else {
                try {
                    exoPlayerView.setResizeMode(AspectRatioFrameLayout.RESIZE_MODE_FIXED_WIDTH);
                } catch (Exception e) {
                }
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
                WindowManager.LayoutParams attrs = getWindow().getAttributes();
                attrs.flags &= ~WindowManager.LayoutParams.FLAG_FULLSCREEN;
                attrs.flags &= ~WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
                getWindow().setAttributes(attrs);
                getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                    attrs.flags &= ~WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS;
                    getWindow().setAttributes(attrs);
                }
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    private final Handler dataHandler = new Handler(message -> {
        if (message.what == Constant.HANDLER_SUCCESS) {
            final Setting setting = SessionManager.get().getSettingModel();
            final boolean isForceUpdate = setting.getForce_update() == ZERO ? FALSE : TRUE;
            final int currentAppVersionCode = Utils.getAppVersionCode(mActivity.getApplicationContext());
            final int forceAppVersionCode = setting.getForce_version_code();
            if (currentAppVersionCode < forceAppVersionCode) {
                final String forceTitle = setting.getForce_title();
                final String forceMessage = setting.getForce_message();
                final String forceYesBtn = setting.getForce_yes_button();
                final String forceNoBtn = setting.getForce_no_button();
                final String forceAPKLink = setting.getForce_apk_link();
                final String updateUrl = DEFAULT_UPDATE_URL + mActivity.getPackageName();

                final MessageDialog dialog = MessageDialog.build()
                        .setTitle(forceTitle)
                        .setMessage(forceMessage)
                        .setCancelable(false);

                //Dialog Negative Button On Click
                if (isForceUpdate) {
                    dialog.setCancelButton(forceNoBtn, (baseDialog, v) -> {
                        (mActivity).finish();
                        (mActivity).overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
                        return false;
                    });
                } else {
                    dialog.setCancelButton(forceNoBtn, (baseDialog, v) -> {
                        dialog.dismiss();
                        return false;
                    });
                }

                //Dialog Positive Button On Click
                dialog.setOkButton(forceYesBtn, (baseDialog, v) -> {
                    if (Utils.isEmpty(forceAPKLink)) {
                        Utils.openStore(mActivity, updateUrl, TRUE);
                    } else {
                        Utils.openStore(mActivity, forceAPKLink, TRUE);
                    }
                    return false;
                });
                dialog.show();
            }
        }
        return true;
    });

    /**
     * Looking for request the http call
     */
    private void requestAction() {
        try {
            showFailedView(FALSE, "");
            showNoItemView(FALSE);
            new Handler().postDelayed(this::callAPIRequest, Constant.DELAY_TIME);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Call API request
     */
    private void callAPIRequest() {
        try {
            ApiInterface apiInterface = RestAdapter.createAPI(mActivity);

            Call<CallbackChannel> callbackCall = apiInterface.getSingleChannel(Utils.getAPIKey(mActivity));

            callbackCall.enqueue(new Callback<CallbackChannel>() {
                @Override
                public void onResponse(@NonNull Call<CallbackChannel> call, @NonNull Response<CallbackChannel> response) {
                    CallbackChannel resp = response.body();
                    if (resp != null && resp.status.equals(Constant.SUCCESS)) {
                        showAPIResult(resp.posts);
                    } else {
                        onFailRequest();
                    }
                }

                @Override
                public void onFailure(@NonNull Call<CallbackChannel> call, @NonNull Throwable t) {
                    if (!call.isCanceled()) onFailRequest();
                }

            });
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Show API response to list
     */
    private void showAPIResult(final List<Channel> channels) {
        try {
            if (channels.size() == ZERO) {
                showNoItemView(TRUE);
            } else {
                try {
                    obj = channels.get(ZERO);
                    loadSpinnerData();
                    openVideo();
                } catch (Exception e) {
                    Utils.getErrors(e);
                }
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    private static final int PORTRAIT_ORIENTATION = ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT;
    private static final int LANDSCAPE_ORIENTATION = ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE;
    private boolean mAutoRotation = false;

    private void setYouTubeConfig(String strVideoId, String strType, int isPlayingVideo) {
        try {
            layoutVideo.setVisibility(View.VISIBLE);
            layoutVideo.removeAllViews();
            youTubePlayerView = new YouTubePlayerView(this);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            youTubePlayerView.setLayoutParams(params);
            youTubePlayerView.setEnableAutomaticInitialization(false);

            full_screen_view_container = findViewById(R.id.full_screen_view_container);
            getLifecycle().addObserver(youTubePlayerView);

            IFramePlayerOptions iFramePlayerOptions;
            if (strType.equalsIgnoreCase(TYPE_LIST)) {
                iFramePlayerOptions = new IFramePlayerOptions.Builder()
                        .controls(1)
                        .fullscreen(1)
                        .autoplay(1)
                        .listType("playlist")
                        .list(strVideoId)
                        .build();
            } else {
                iFramePlayerOptions = new IFramePlayerOptions.Builder()
                        .controls(1)
                        .fullscreen(1)
                        .autoplay(1)
                        .build();
            }

            youTubePlayerView.initialize(new AbstractYouTubePlayerListener() {
                @Override
                public void onReady(@NonNull YouTubePlayer youTubePlayer) {
                    mYouTubePlayer = youTubePlayer;
                    if (!strType.equalsIgnoreCase(TYPE_LIST)) {
                        youTubePlayer.loadVideo(strVideoId, 0);
                    }
                }

                @Override
                public void onError(@NonNull YouTubePlayer youTubePlayer, @NonNull PlayerConstants.PlayerError error) {
                    super.onError(youTubePlayer, error);
                    String err = error.toString();
                    Toast.makeText(mActivity, err, Toast.LENGTH_LONG).show();
                }
            }, true, iFramePlayerOptions);
            layoutVideo.addView(youTubePlayerView);
        } catch (Exception e) {
            Utils.getErrors(e);
        }

        try {
            youTubePlayerView.addFullscreenListener(new FullscreenListener() {
                @Override
                public void onEnterFullscreen(@NonNull View view, @NonNull Function0<Unit> function0) {
                    youTubePlayerView.setVisibility(View.GONE);
                    full_screen_view_container.setVisibility(View.VISIBLE);
                    full_screen_view_container.addView(view);
                    hideShowOtherComponent(View.GONE);
                    mAutoRotation = true;
                }

                @Override
                public void onExitFullscreen() {
                    youTubePlayerView.setVisibility(View.VISIBLE);
                    full_screen_view_container.setVisibility(View.GONE);
                    full_screen_view_container.removeAllViews();
                    hideShowOtherComponent(View.VISIBLE);
                    mAutoRotation = false;
                }
            });

        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    public void openVideo() {
        try {
            streamLinkPlaying = niceSpinner.getSelectedIndex() == ZERO ? obj.channel_url.trim() : obj.channel_url_two.trim();
            nonVideoLayout.setVisibility(View.GONE);
            videoLayout.setVisibility(View.GONE);
            exoPlayerView.setVisibility(View.GONE);
            layoutVideo.setVisibility(View.GONE);
            mWebView.setVisibility(View.GONE);

            txtChannelName.setText(obj.channel_name);
            if (bTotalCount <= ZERO) {
                bTotalCount = obj.total_count;
            }
            txtChannelCount.setText(Utils.Format(bTotalCount));

            Utils.setDescriptionWebView(mActivity, obj, txtDescription);
            try {
                Utils.setChannelImageView(mActivity, obj, niceSpinner.getSelectedIndex(), imgChannel);
            } catch (Exception e) {
                Utils.getErrors(e);
            }

            if (obj.channel_type.equalsIgnoreCase(TYPE_STREAMING)) {

                setImmersionBarTheme();

                if (simpleExoPlayer.isPlaying()) {
                    releasePlayer();
                }
                findViewById(R.id.ex_error_player).setVisibility(View.GONE);
                exoPlayerView = findViewById(R.id.exoPlayerView);
                exoPlayerView.setVisibility(View.VISIBLE);
                trackSelector = new DefaultTrackSelector(this);

                final String agent = Utils.isEmpty(obj.channel_user_agent) ? Util.getUserAgent(this, getResources().getString(R.string.app_name)) : obj.channel_user_agent;

                final HttpDataSource.Factory httpDataSourceFactory = new DefaultHttpDataSource.Factory().setAllowCrossProtocolRedirects(true);
                DataSource.Factory dataSourceFactory = () -> {
                    HttpDataSource dataSource = httpDataSourceFactory.createDataSource();
                    // Set a custom authentication request header.
                    dataSource.setRequestProperty("User-Agent", agent);
                    return dataSource;
                };
                final MediaSource.Factory f = new DefaultMediaSourceFactory(dataSourceFactory);
                simpleExoPlayer = new ExoPlayer.Builder(this).setMediaSourceFactory(f).setTrackSelector(trackSelector).build();

                final MediaItem mediaItem = MediaItem.fromUri(streamLinkPlaying);
                simpleExoPlayer.addMediaItem(mediaItem);
                simpleExoPlayer.prepare();
                simpleExoPlayer.setAudioAttributes(AudioAttributes.DEFAULT, /* handleAudioFocus= */ true);
                simpleExoPlayer.setPlayWhenReady(true);
                exoPlayerView.setPlayer(simpleExoPlayer);

                simpleExoPlayer.addListener(new Player.Listener() {
                    @Override
                    public void onPlaybackStateChanged(int state) {
                        if (state == ExoPlayer.STATE_READY) {
                            exoCustomControl(View.VISIBLE);
                        }
                        Utils.sout("state:: " + state);
                    }

                    @Override
                    public void onPlayerError(PlaybackException error) {
                        Utils.sout("Error STate: " + error.errorCode + " >> " + error.getErrorCodeName());
                        if (error.errorCode == PlaybackException.ERROR_CODE_BEHIND_LIVE_WINDOW) {
                            simpleExoPlayer.seekToDefaultPosition();
                            simpleExoPlayer.prepare();
                            simpleExoPlayer.setPlayWhenReady(true);
                        } else {
                            exoCustomControl(View.GONE);
                            findViewById(R.id.ex_error_player).setVisibility(View.VISIBLE);
                        }
                    }
                });

                if (isFullscreen) {
                    hideShowOtherComponent(View.GONE);
                } else {
                    hideShowOtherComponent(View.VISIBLE);
                }

            } else if (obj.channel_type.equalsIgnoreCase(TYPE_YOUTUBE)) {
                try {
                    youTubePlayerView.release();
                } catch (Exception e) {
                }
                try {
                    setImmersionBarTheme();
                    strVideoId = niceSpinner.getSelectedIndex() == ZERO ? obj.channel_video_id.trim() : obj.channel_video_id_two.trim();
                    strType = niceSpinner.getSelectedIndex() == ZERO ? obj.channel_type_1 : obj.channel_type_2;
                    try {
                        setYouTubeConfig(strVideoId, strType, ZERO);
                    } catch (Exception e) {
                        Utils.getErrors(e);
                    }
                } catch (Exception e) {
                    Utils.getErrors(e);
                }

            } else {
                nonVideoLayout.setVisibility(View.VISIBLE);
                videoLayout.setVisibility(View.VISIBLE);
                View nonVideoLayout = findViewById(R.id.nonVideoLayout); // Your own view, read class comments
                ViewGroup videoLayout = findViewById(R.id.videoLayout); // Your own view, read class comments
                View loadingView = getLayoutInflater().inflate(R.layout.view_loading_video, null); // Your own view, read class comments
                webChromeClient = new VideoEnabledWebChromeClient(nonVideoLayout, videoLayout, loadingView, mWebView) {
                    @Override
                    public void onProgressChanged(WebView view, int progress) {
                    }
                };
                webChromeClient.setOnToggledFullscreen(fullscreenCallback);
                mWebView.setWebChromeClient(webChromeClient);
                mWebView.loadUrl(streamLinkPlaying);
                if (isFullscreen) {
                    fullscreenCallback.toggledFullscreen(true);
                }
            }

        } catch (Exception e) {
            Utils.getErrors(e);
        } finally {
            insertLinkCount();
        }
    }

    private boolean isWebViewFullScreen = false;
    final VideoEnabledWebChromeClient.ToggledFullscreenCallback fullscreenCallback = new VideoEnabledWebChromeClient.ToggledFullscreenCallback() {

        private void hideShowOtherComponent(int isVisible) {
            findViewById(R.id.appbar).setVisibility(isVisible);
            findViewById(R.id.topLayout).setVisibility(isVisible);
            findViewById(R.id.descriptionLayout).setVisibility(isVisible);
        }

        @Override
        public void toggledFullscreen(boolean fullscreen) {
            // Your code to handle the full-screen change, for example showing and hiding the title bar. Example:
            isWebViewFullScreen = fullscreen;
            if (fullscreen) {
                setRequestedOrientation(LANDSCAPE_ORIENTATION);
                WindowManager.LayoutParams attrs = getWindow().getAttributes();
                attrs.flags |= WindowManager.LayoutParams.FLAG_FULLSCREEN;
                attrs.flags |= WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
                getWindow().setAttributes(attrs);
                hideShowOtherComponent(View.GONE);
                getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LOW_PROFILE
                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                    attrs.flags |= WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS;
                    getWindow().setAttributes(attrs);
                }
            } else {
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
                hideShowOtherComponent(View.VISIBLE);
                WindowManager.LayoutParams attrs = getWindow().getAttributes();
                attrs.flags &= ~WindowManager.LayoutParams.FLAG_FULLSCREEN;
                attrs.flags &= ~WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON;
                getWindow().setAttributes(attrs);
                getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                    attrs.flags &= ~WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS;
                    getWindow().setAttributes(attrs);
                }
            }

        }
    };

    private void loadSpinnerData() {
        streamLinkPlaying = obj.channel_url;
        try {
            dataset.clear();
            dataset.add(obj.link1_label);
            dataset.add(obj.link2_label);
            niceSpinner.attachDataSource(dataset);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Failed request call when Fail from network call or Failure status
     */
    private void onFailRequest() {
        try {
            if (Utils.isOnline(mActivity)) {
                showNoItemView(TRUE);
            } else {
                showFailedView(TRUE, getString(R.string.no_internet_text));
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Display error message if failed to load data
     */
    private void showFailedView(boolean show, String message) {
        try {
            View failedView = findViewById(R.id.layoutFailed);
            ((TextView) findViewById(R.id.failedMessage)).setText(message);
            if (show) {
                mainContainer.setVisibility(View.GONE);
                failedView.setVisibility(View.VISIBLE);
            } else {
                mainContainer.setVisibility(View.VISIBLE);
                failedView.setVisibility(View.GONE);
            }
            (findViewById(R.id.layoutNoConnection)).setOnClickListener(view -> new Handler().postDelayed(this::requestAction, CLICK_DELAY_TIME));
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Display no found message if data not found
     */
    private void showNoItemView(boolean show) {
        try {
            View noItemView = findViewById(R.id.layoutNoItem);
            ((TextView) findViewById(R.id.noItemMessage)).setText(R.string.no_post_found);
            if (show) {
                mainContainer.setVisibility(View.GONE);
                noItemView.setVisibility(View.VISIBLE);
            } else {
                mainContainer.setVisibility(View.VISIBLE);
                noItemView.setVisibility(View.GONE);
            }
            (findViewById(R.id.layoutNoItemFound)).setOnClickListener(view -> requestAction());
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    private void insertLinkCount() {

        final BaseTask baseTask = new BaseTask() {
            @Override
            public void setUiForLoading() {
                super.setUiForLoading();
            }

            @Override
            public Object call() {
                try {
                    final ApiInterface apiInterface = RestAdapter.createAPI(mActivity);

                    Call<CallbackUser> callbackCall;

                    if (niceSpinner.getSelectedIndex() == ZERO) {
                        callbackCall = apiInterface.insertLinkCount(Utils.getAPIKey(mActivity), ONE, ZERO, obj.channel_type);
                    } else {
                        callbackCall = apiInterface.insertLinkCount(Utils.getAPIKey(mActivity), ZERO, ONE, obj.channel_type);
                    }

                    callbackCall.enqueue(new Callback<CallbackUser>() {
                        @Override
                        public void onResponse(@NonNull Call<CallbackUser> call, @NonNull Response<CallbackUser> response) {
                            final CallbackUser resp = response.body();

                            if (resp != null && resp.status.equals(Constant.SUCCESS)) {
                                bTotalCount = resp.data.total_count;
                            }
                        }

                        @Override
                        public void onFailure(@NonNull Call<CallbackUser> call, @NonNull Throwable t) {
                        }
                    });
                } catch (Exception e) {
                    Utils.getErrors(e);
                }
                return bTotalCount;
            }

            @Override
            public void setDataAfterLoading(Object result) {
                txtChannelCount.setText(Utils.Format((int) result));
            }

        };

        final TaskRunner runner = new TaskRunner();
        runner.executeAsync(baseTask);
    }

    @Override
    public void onConfigurationChanged(final Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        try {
            if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE) {
                findViewById(R.id.adsBottomView).setVisibility(View.GONE);
            } else {
                findViewById(R.id.adsBottomView).setVisibility(View.VISIBLE);
            }
        } catch (Exception ignored) {
        }
    }

    protected void releasePlayer() {
        try {
            if (simpleExoPlayer != null) {
                simpleExoPlayer.release();
                simpleExoPlayer = null;
                trackSelector = null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Cancel call if its running
     */
    @Override
    public void onDestroy() {
        super.onDestroy();
        releasePlayer();
        try {
            youTubePlayerView.release();
        } catch (Exception e) {
            Utils.getErrors(e);
        }
        try {
            if (mWebView != null) {
                mWebView.loadUrl("");
            }
        } catch (Exception ignored) {
        }
    }

    @Override
    public void onBackPressed() {
//        super.onBackPressed();
        exitApp();
    }

    private void exitApp() {
        try {
            if ((System.currentTimeMillis() - exitTime) > DEFAULT_DELAY) {
                try {
                    if (obj.channel_type.equalsIgnoreCase(TYPE_STREAMING)) {
                        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                            hideShowOtherComponent(View.VISIBLE);
                            return;
                        }
                    } else if (obj.channel_type.equalsIgnoreCase(TYPE_YOUTUBE)) {
                        if (mAutoRotation) {
                            mYouTubePlayer.toggleFullscreen();
                            return;
                        }
                    } else {
                        if (isWebViewFullScreen) {
                            fullscreenCallback.toggledFullscreen(false);
                            return;
                        }
                        webChromeClient.onBackPressed();
                        if (!webChromeClient.onBackPressed()) {
                            if (mWebView.canGoBack()) {
                                mWebView.goBack();
                                return;
                            }
                        }
                    }
                } catch (Exception e) {
                    Utils.getErrors(e);
                }
                try {
                    final Snackbar snackbar = Snackbar.make(findViewById(android.R.id.content), getString(R.string.press_again_to_exit), Snackbar.LENGTH_LONG);
                    View sbView = snackbar.getView();
//                    TextView textView = sbView.findViewById(R.id.snackbar_text);
//                    textView.setTextColor(Color.YELLOW);
//                    snackbar.show();
                } catch (Exception e) {
                    Utils.getErrors(e);
                    Toast.makeText(this, getString(R.string.press_again_to_exit), Toast.LENGTH_SHORT).show();
                }
                exitTime = System.currentTimeMillis();
            } else {
                finish();
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            if (simpleExoPlayer != null) {
                simpleExoPlayer.seekToDefaultPosition();
                simpleExoPlayer.prepare();
                simpleExoPlayer.setPlayWhenReady(true);
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            if (simpleExoPlayer != null) {
                if (simpleExoPlayer.isPlaying()) {
                    simpleExoPlayer.pause();
                }
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }
}
